clear all

* Set Folder

cd ..\Outputs

* Call database of merged unemployment and real GDP growth

use vin_all, clear

* Define the matrix of long-run restrictions

matrix lr = (.,0\.,.)

gen dlogY_BQ_supply=.
gen dlogY_BQ_demand=.
gen dlogY_RT=.
gen dlogY_RT0=.

local sizeofwindow=120

gen dlogY_BQ_supply_shock=.
gen dlogY_BQ_demand_shock=.
forvalues mm=1(1)8 {
	gen dlogY_BQ_supply_shock_L`mm'=.
	gen dlogY_BQ_demand_shock_L`mm'=.
}

quiet forvalues yy=69(1)116 {

	forvalues qq=1(1)4 {
	
		if `yy'<100 local str0="`yy'Q`qq'"
		if `yy'>=100 & `yy'<110 {
			local yy1=`yy'-100
			local str0="0`yy1'Q`qq'"
		}
		if `yy'>=110 {
			local yy1=`yy'-100
			local str0="`yy1'Q`qq'"
		}
		
		summ t if GROUTPUT`str0'!=.
		local lastt=r(max)
		
		noisily di "`yy'Q`qq'"
		svar GROUTPUT`str0' RUC`str0' if t>`=`lastt'-`sizeofwindow'', lags(1/8) lreq(lr) 
		matrix B=e(B)
		matrix invB=inv(B)
		capture drop resid*
		predict residGY if e(sample), resid equation(#1)
		predict residUE if e(sample), resid equation(#2)
	
		capture drop temp*
		gen temp_supply=invB[1,1]*residGY+invB[1,2]*residUE
		gen temp_demand=invB[2,1]*residGY+invB[2,2]*residUE
	
		irf create lr, set(lrirf, replace) step(100) replace
		
		sum t if e(sample)
		gen step=r(max)-_n
		local smplT=r(max)
		
		replace dlogY_BQ_supply_shock=temp_supply if t<=`smplT' & dlogY_BQ_supply_shock==.
		replace dlogY_BQ_demand_shock=temp_demand if t<=`smplT' & dlogY_BQ_demand_shock==.
		
		forvalues mm=1(1)8 {
			replace dlogY_BQ_supply_shock_L`mm'=l`mm'.temp_supply if t<=`smplT' & dlogY_BQ_supply_shock_L`mm'==.
			replace dlogY_BQ_demand_shock_L`mm'=l`mm'.temp_demand if t<=`smplT' & dlogY_BQ_demand_shock_L`mm'==.
		}
		
		* Calculate historical decomposition: supply side
		
		preserve
		
		use lrirf.irf, clear
		keep if response=="GROUTPUT`str0'"
		keep if impulse=="GROUTPUT`str0'"
		keep step sirf
		save temp1, replace

		restore
		
		joinby step using temp1, unmatched(master)
		drop _merge
		
		gen temp_dlogY_BQ_supply=temp_supply*sirf 
		sum temp_dlogY_BQ_supply
		replace dlogY_BQ_supply=r(mean)*r(N) if t<=`smplT' & dlogY_BQ_supply==.
		
		capture drop sirf

		* Calculate historical decomposition: demand side
		
		preserve
		
		use lrirf.irf, clear
		keep if response=="GROUTPUT`str0'"
		keep if impulse=="RUC`str0'"
		keep step sirf
		save temp1, replace

		restore
		
		joinby step using temp1, unmatched(master)
		drop _merge
		
		gen temp_dlogY_BQ_demand=temp_demand*sirf 
		sum temp_dlogY_BQ_demand
		replace dlogY_BQ_demand=r(mean)*r(N) if t<=`smplT' & dlogY_BQ_demand==.
			
		capture drop step
		capture drop sirf

		* Actual growth rate of output
		
		sum GROUTPUT`str0'
		gen demeaned_GROUTPUT`str0'=GROUTPUT`str0'-r(mean)
		
		sum t if year==1900+`yy' & quarter==`qq'
		replace dlogY_RT=demeaned_GROUTPUT`str0' if t==`smplT'
		
		if `yy'==96 & `qq'==2 {
			local smplT1=`smplT'-1
			replace dlogY_RT=demeaned_GROUTPUT`str0' if t==`smplT1'
		}
		
		capture drop demeaned*

		* Growth rate is not demeaned
		
		replace dlogY_RT0=GROUTPUT`str0' if t==`smplT'
		
		if `yy'==96 & `qq'==2 {
			local smplT1=`smplT'-1
			replace dlogY_RT0=GROUTPUT`str0' if t==`smplT1'
		}
	}
}

gen dlogY_BQ_total=dlogY_BQ_supply+dlogY_BQ_demand
tsset t
drop if year<1969

rename dlogY_BQ_supply_shock  dlogY_BQrw`sizeofwindow'_supply_shock
rename dlogY_BQ_demand_shock  dlogY_BQrw`sizeofwindow'_demand_shock
forvalues mm=1(1)8 {
	rename dlogY_BQ_supply_shock_L`mm'  dlogY_BQrw`sizeofwindow'_supply_shock_L`mm'
	rename dlogY_BQ_demand_shock_L`mm'  dlogY_BQrw`sizeofwindow'_demand_shock_L`mm'
}
		
keep year quarter dlogY_BQ* dlogY_RT dlogY_RT0

rename dlogY_BQ_supply dlogY_BQrw`sizeofwindow'_supply
rename dlogY_BQ_demand dlogY_BQrw`sizeofwindow'_demand
rename dlogY_BQ_total  dlogY_BQrw`sizeofwindow'_total 
rename dlogY_RT        dlogY_RTrw`sizeofwindow'
rename dlogY_RT0       dlogY_RT0rw`sizeofwindow'

save BQrollingwindow`sizeofwindow', replace

erase temp1.dta
